package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiResourceType;
import ru.yandex.qe.dispenser.api.v1.DiUnit;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource type")
public final class BaseResourceTypeDto {

    private final long id;
    private final String key;
    private final String name;
    private final long providerId;
    private final DiResourceType resourceType;
    private final DiUnit baseUnit;

    @JsonCreator
    public BaseResourceTypeDto(@JsonProperty("id") long id,
                               @JsonProperty("key") String key,
                               @JsonProperty("name") String name,
                               @JsonProperty("providerId") long providerId,
                               @JsonProperty("resourceType") DiResourceType resourceType,
                               @JsonProperty("baseUnit") DiUnit baseUnit) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.providerId = providerId;
        this.resourceType = resourceType;
        this.baseUnit = baseUnit;
    }

    @ApiModelProperty("Base resource type id")
    public long getId() {
        return id;
    }

    @ApiModelProperty("Base resource type key")
    public String getKey() {
        return key;
    }

    @ApiModelProperty("Base resource type name")
    public String getName() {
        return name;
    }

    @ApiModelProperty("Provider id, this provider receives this type of base resources")
    public long getProviderId() {
        return providerId;
    }

    @ApiModelProperty("Internal resource type")
    public DiResourceType getResourceType() {
        return resourceType;
    }

    @ApiModelProperty("Base unit of measure for this type of base resources")
    public DiUnit getBaseUnit() {
        return baseUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceTypeDto that = (BaseResourceTypeDto) o;
        return id == that.id &&
                providerId == that.providerId &&
                Objects.equals(key, that.key) &&
                Objects.equals(name, that.name) &&
                resourceType == that.resourceType &&
                baseUnit == that.baseUnit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, name, providerId, resourceType, baseUnit);
    }

    @Override
    public String toString() {
        return "BaseResourceTypeDto{" +
                "id=" + id +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", providerId=" + providerId +
                ", resourceType=" + resourceType +
                ", baseUnit=" + baseUnit +
                '}';
    }

}
