package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiService;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Page of base resource types")
public final class BaseResourceTypesPageDto {

    private final List<BaseResourceTypeDto> types;
    private final Map<Long, DiService> providers;
    private final Long nextFrom;

    @JsonCreator
    public BaseResourceTypesPageDto(@JsonProperty("types") List<BaseResourceTypeDto> types,
                                    @JsonProperty("providers") Map<Long, DiService> providers,
                                    @JsonProperty("nextFrom") Long nextFrom) {
        this.types = types;
        this.providers = providers;
        this.nextFrom = nextFrom;
    }

    @ApiModelProperty("Base resource types list")
    public List<BaseResourceTypeDto> getTypes() {
        return types;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("Providers referenced by base resource types, indexed by provider id")
    public Map<Long, DiService> getProviders() {
        return providers;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("Id of the last base resource type on the page, use it to load the next page")
    public Optional<Long> getNextFrom() {
        return Optional.ofNullable(nextFrom);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceTypesPageDto that = (BaseResourceTypesPageDto) o;
        return Objects.equals(types, that.types) &&
                Objects.equals(providers, that.providers) &&
                Objects.equals(nextFrom, that.nextFrom);
    }

    @Override
    public int hashCode() {
        return Objects.hash(types, providers, nextFrom);
    }

    @Override
    public String toString() {
        return "BaseResourceTypesPageDto{" +
                "types=" + types +
                ", providers=" + providers +
                ", nextFrom=" + nextFrom +
                '}';
    }

}
