package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("New base resource limit")
public class CreateBaseResourceLimitDto {

    private final Long baseResourceId;
    private final Long campaignId;
    private final DiAmount limit;

    @JsonCreator
    public CreateBaseResourceLimitDto(@JsonProperty("baseResourceId") Long baseResourceId,
                                      @JsonProperty("campaignId") Long campaignId,
                                      @JsonProperty("limit") DiAmount limit) {
        this.baseResourceId = baseResourceId;
        this.campaignId = campaignId;
        this.limit = limit;
    }

    @ApiModelProperty("Base resource id")
    public Optional<Long> getBaseResourceId() {
        return Optional.ofNullable(baseResourceId);
    }

    @ApiModelProperty("Campaign id")
    public Optional<Long> getCampaignId() {
        return Optional.ofNullable(campaignId);
    }

    @ApiModelProperty("Limit value")
    public Optional<DiAmount> getLimit() {
        return Optional.ofNullable(limit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateBaseResourceLimitDto that = (CreateBaseResourceLimitDto) o;
        return Objects.equals(baseResourceId, that.baseResourceId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(baseResourceId, campaignId, limit);
    }

    @Override
    public String toString() {
        return "CreateBaseResourceLimitDto{" +
                "baseResourceId=" + baseResourceId +
                ", campaignId=" + campaignId +
                ", limit=" + limit +
                '}';
    }

}
