package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiCampaign;
import ru.yandex.qe.dispenser.api.v1.DiSegment;
import ru.yandex.qe.dispenser.api.v1.DiService;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Single base resource limit")
public final class SingleBaseResourceLimitDto {

    private final BaseResourceLimitDto limit;
    private final BaseResourceDto baseResource;
    private final BaseResourceTypeDto baseResourceType;
    private final Map<Long, DiService> providers;
    private final DiCampaign campaign;
    private final Map<Long, DiSegment> segments;

    @JsonCreator
    public SingleBaseResourceLimitDto(@JsonProperty("limit") BaseResourceLimitDto limit,
                                      @JsonProperty("baseResource") BaseResourceDto baseResource,
                                      @JsonProperty("baseResourceType") BaseResourceTypeDto baseResourceType,
                                      @JsonProperty("providers") Map<Long, DiService> providers,
                                      @JsonProperty("campaign") DiCampaign campaign,
                                      @JsonProperty("segments") Map<Long, DiSegment> segments) {
        this.limit = limit;
        this.baseResource = baseResource;
        this.baseResourceType = baseResourceType;
        this.providers = providers;
        this.campaign = campaign;
        this.segments = segments;
    }

    @ApiModelProperty("Base resource limit")
    public BaseResourceLimitDto getLimit() {
        return limit;
    }

    @ApiModelProperty("Base resource referenced by this limit")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<BaseResourceDto> getBaseResource() {
        return Optional.ofNullable(baseResource);
    }

    @ApiModelProperty("Base resource type referenced by the base resource")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<BaseResourceTypeDto> getBaseResourceType() {
        return Optional.ofNullable(baseResourceType);
    }

    @ApiModelProperty("Referenced providers, indexed by id")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<Long, DiService> getProviders() {
        return providers;
    }

    @ApiModelProperty("Campaign")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<DiCampaign> getCampaign() {
        return Optional.ofNullable(campaign);
    }

    @ApiModelProperty("Segments")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<Long, DiSegment> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SingleBaseResourceLimitDto that = (SingleBaseResourceLimitDto) o;
        return Objects.equals(limit, that.limit) &&
                Objects.equals(baseResource, that.baseResource) &&
                Objects.equals(baseResourceType, that.baseResourceType) &&
                Objects.equals(providers, that.providers) &&
                Objects.equals(campaign, that.campaign) &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(limit, baseResource, baseResourceType, providers, campaign, segments);
    }

    @Override
    public String toString() {
        return "SingleBaseResourceLimitDto{" +
                "limit=" + limit +
                ", baseResource=" + baseResource +
                ", baseResourceType=" + baseResourceType +
                ", providers=" + providers +
                ", campaign=" + campaign +
                ", segments=" + segments +
                '}';
    }

}
