package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiBotBigOrder;
import ru.yandex.qe.dispenser.api.v1.DiCampaign;
import ru.yandex.qe.dispenser.api.v1.DiResource;
import ru.yandex.qe.dispenser.api.v1.DiSegment;
import ru.yandex.qe.dispenser.api.v1.DiService;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Single base resource mapping")
public final class SingleBaseResourceMappingDto {

    private final BaseResourceMappingDto mapping;
    private final BaseResourceDto baseResource;
    private final BaseResourceTypeDto baseResourceType;
    private final Map<Long, DiService> providers;
    private final DiCampaign campaign;
    private final DiBotBigOrder bigOrder;
    private final Map<Long, DiSegment> segments;
    private final Map<Long, DiResource> resources;

    @JsonCreator
    public SingleBaseResourceMappingDto(@JsonProperty("mapping") BaseResourceMappingDto mapping,
                                        @JsonProperty("baseResource") BaseResourceDto baseResource,
                                        @JsonProperty("baseResourceType") BaseResourceTypeDto baseResourceType,
                                        @JsonProperty("providers") Map<Long, DiService> providers,
                                        @JsonProperty("campaign") DiCampaign campaign,
                                        @JsonProperty("bigOrder") DiBotBigOrder bigOrder,
                                        @JsonProperty("segments") Map<Long, DiSegment> segments,
                                        @JsonProperty("resources") Map<Long, DiResource> resources) {
        this.mapping = mapping;
        this.baseResource = baseResource;
        this.baseResourceType = baseResourceType;
        this.providers = providers;
        this.campaign = campaign;
        this.bigOrder = bigOrder;
        this.segments = segments;
        this.resources = resources;
    }

    @ApiModelProperty("Base resource mapping")
    public BaseResourceMappingDto getMapping() {
        return mapping;
    }

    @ApiModelProperty("Base resource referenced by this mapping")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<BaseResourceDto> getBaseResource() {
        return Optional.ofNullable(baseResource);
    }

    @ApiModelProperty("Base resource type referenced by the base resource")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<BaseResourceTypeDto> getBaseResourceType() {
        return Optional.ofNullable(baseResourceType);
    }

    @ApiModelProperty("Referenced providers, indexed by id")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<Long, DiService> getProviders() {
        return providers;
    }

    @ApiModelProperty("Campaign")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<DiCampaign> getCampaign() {
        return Optional.ofNullable(campaign);
    }

    @ApiModelProperty("Big order")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<DiBotBigOrder> getBigOrder() {
        return Optional.ofNullable(bigOrder);
    }

    @ApiModelProperty("Segments")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<Long, DiSegment> getSegments() {
        return segments;
    }

    @ApiModelProperty("Resources")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<Long, DiResource> getResources() {
        return resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SingleBaseResourceMappingDto that = (SingleBaseResourceMappingDto) o;
        return Objects.equals(mapping, that.mapping) &&
                Objects.equals(baseResource, that.baseResource) &&
                Objects.equals(baseResourceType, that.baseResourceType) &&
                Objects.equals(providers, that.providers) &&
                Objects.equals(campaign, that.campaign) &&
                Objects.equals(bigOrder, that.bigOrder) &&
                Objects.equals(segments, that.segments) &&
                Objects.equals(resources, that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mapping, baseResource, baseResourceType, providers, campaign,
                bigOrder, segments, resources);
    }

    @Override
    public String toString() {
        return "ЫштпдуBaseResourceMappingDto{" +
                "mapping=" + mapping +
                ", baseResource=" + baseResource +
                ", baseResourceType=" + baseResourceType +
                ", providers=" + providers +
                ", campaign=" + campaign +
                ", bigOrder=" + bigOrder +
                ", segments=" + segments +
                ", resources=" + resources +
                '}';
    }

}
