package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiService;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Single base resource type")
public final class SingleBaseResourceTypeDto {

    private final BaseResourceTypeDto type;
    private final DiService provider;

    @JsonCreator
    public SingleBaseResourceTypeDto(@JsonProperty("type") BaseResourceTypeDto type,
                                     @JsonProperty("provider") DiService provider) {
        this.type = type;
        this.provider = provider;
    }

    @ApiModelProperty("Base resource type")
    public BaseResourceTypeDto getType() {
        return type;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("Provider referenced by base resource type")
    public Optional<DiService> getProvider() {
        return Optional.ofNullable(provider);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SingleBaseResourceTypeDto that = (SingleBaseResourceTypeDto) o;
        return Objects.equals(type, that.type) &&
                Objects.equals(provider, that.provider);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, provider);
    }

    @Override
    public String toString() {
        return "SingleBaseResourceTypeDto{" +
                "type=" + type +
                ", provider=" + provider +
                '}';
    }

}
