package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource limit update")
public class UpdateBaseResourceLimitDto {

    private final DiAmount limit;

    @JsonCreator
    public UpdateBaseResourceLimitDto(@JsonProperty("limit") DiAmount limit) {
        this.limit = limit;
    }

    @ApiModelProperty("Limit value")
    public Optional<DiAmount> getLimit() {
        return Optional.ofNullable(limit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateBaseResourceLimitDto that = (UpdateBaseResourceLimitDto) o;
        return Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(limit);
    }

    @Override
    public String toString() {
        return "UpdateBaseResourceLimitDto{" +
                "limit=" + limit +
                '}';
    }

}
