package ru.yandex.qe.dispenser.ws.billing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class BillingDryRunRequest {

    private final String currency;
    private final List<BillingDryRunRequestMetric> metrics;

    @JsonCreator
    public BillingDryRunRequest(@JsonProperty("currency") String currency,
                                @JsonProperty("metrics") List<BillingDryRunRequestMetric> metrics) {
        this.currency = currency;
        this.metrics = metrics;
    }

    public String getCurrency() {
        return currency;
    }

    public List<BillingDryRunRequestMetric> getMetrics() {
        return metrics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BillingDryRunRequest that = (BillingDryRunRequest) o;
        return Objects.equals(currency, that.currency) &&
                Objects.equals(metrics, that.metrics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, metrics);
    }

    @Override
    public String toString() {
        return "BillingDryRunRequest{" +
                "currency='" + currency + '\'' +
                ", metrics=" + metrics +
                '}';
    }

}
