package ru.yandex.qe.dispenser.ws.billing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BillingDryRunResponse {

    private final String currency;
    private final List<BillingDryRunResponseCalculatedItem> calculatedItems;
    private final List<BillingDryRunResponseMetric> unresolvedMetrics;

    @JsonCreator
    public BillingDryRunResponse(
            @JsonProperty("currency") String currency,
            @JsonProperty("calculatedItems") List<BillingDryRunResponseCalculatedItem> calculatedItems,
            @JsonProperty("unresolvedMetrics") List<BillingDryRunResponseMetric> unresolvedMetrics) {
        this.currency = currency;
        this.calculatedItems = calculatedItems;
        this.unresolvedMetrics = unresolvedMetrics;
    }

    public String getCurrency() {
        return currency;
    }

    public List<BillingDryRunResponseCalculatedItem> getCalculatedItems() {
        return calculatedItems;
    }

    public List<BillingDryRunResponseMetric> getUnresolvedMetrics() {
        return unresolvedMetrics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BillingDryRunResponse that = (BillingDryRunResponse) o;
        return Objects.equals(currency, that.currency) &&
                Objects.equals(calculatedItems, that.calculatedItems) &&
                Objects.equals(unresolvedMetrics, that.unresolvedMetrics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, calculatedItems, unresolvedMetrics);
    }

    @Override
    public String toString() {
        return "BillingDryRunResponse{" +
                "currency='" + currency + '\'' +
                ", calculatedItems=" + calculatedItems +
                ", unresolvedMetrics=" + unresolvedMetrics +
                '}';
    }

}
