package ru.yandex.qe.dispenser.ws.billing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BillingDryRunResponseCalculatedItem {

    private final String skuId;
    private final BigDecimal pricingQuantity;
    private final BigDecimal cost;

    @JsonCreator
    public BillingDryRunResponseCalculatedItem(@JsonProperty("skuId") String skuId,
                                               @JsonProperty("pricingQuantity") BigDecimal pricingQuantity,
                                               @JsonProperty("cost") BigDecimal cost) {
        this.skuId = skuId;
        this.pricingQuantity = pricingQuantity;
        this.cost = cost;
    }

    public String getSkuId() {
        return skuId;
    }

    public BigDecimal getPricingQuantity() {
        return pricingQuantity;
    }

    public BigDecimal getCost() {
        return cost;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BillingDryRunResponseCalculatedItem that = (BillingDryRunResponseCalculatedItem) o;
        return Objects.equals(skuId, that.skuId) &&
                Objects.equals(pricingQuantity, that.pricingQuantity) &&
                Objects.equals(cost, that.cost);
    }

    @Override
    public int hashCode() {
        return Objects.hash(skuId, pricingQuantity, cost);
    }

    @Override
    public String toString() {
        return "BillingDryRunResponseCalculatedItem{" +
                "skuId='" + skuId + '\'' +
                ", pricingQuantity=" + pricingQuantity +
                ", cost=" + cost +
                '}';
    }

}
