package ru.yandex.qe.dispenser.ws.billing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BillingDryRunResponseMetric {

    private final String id;
    private final String schema;
    private final Map<String, Object> tags;
    private final Map<String, Object> labels;
    private final long sourceWt;
    private final String sourceId;
    private final String version;
    private final BillingDryRunResponseMetricUsage usage;
    @Nullable
    private final BigDecimal pricingQuantity;

    @JsonCreator
    public BillingDryRunResponseMetric(@JsonProperty("id") String id,
                                       @JsonProperty("schema") String schema,
                                       @JsonProperty("tags") Map<String, Object> tags,
                                       @JsonProperty("labels") Map<String, Object> labels,
                                       @JsonProperty("sourceWt") long sourceWt,
                                       @JsonProperty("sourceId") String sourceId,
                                       @JsonProperty("version") String version,
                                       @JsonProperty("usage") BillingDryRunResponseMetricUsage usage,
                                       @JsonProperty("pricingQuantity") @Nullable BigDecimal pricingQuantity) {
        this.id = id;
        this.schema = schema;
        this.tags = tags;
        this.labels = labels;
        this.sourceWt = sourceWt;
        this.sourceId = sourceId;
        this.version = version;
        this.usage = usage;
        this.pricingQuantity = pricingQuantity;
    }

    public String getId() {
        return id;
    }

    public String getSchema() {
        return schema;
    }

    public Map<String, Object> getTags() {
        return tags;
    }

    public Map<String, Object> getLabels() {
        return labels;
    }

    public long getSourceWt() {
        return sourceWt;
    }

    public String getSourceId() {
        return sourceId;
    }

    public String getVersion() {
        return version;
    }

    public BillingDryRunResponseMetricUsage getUsage() {
        return usage;
    }

    public Optional<BigDecimal> getPricingQuantity() {
        return Optional.ofNullable(pricingQuantity);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BillingDryRunResponseMetric that = (BillingDryRunResponseMetric) o;
        return sourceWt == that.sourceWt &&
                Objects.equals(id, that.id) &&
                Objects.equals(schema, that.schema) &&
                Objects.equals(tags, that.tags) &&
                Objects.equals(labels, that.labels) &&
                Objects.equals(sourceId, that.sourceId) &&
                Objects.equals(version, that.version) &&
                Objects.equals(usage, that.usage) &&
                Objects.equals(pricingQuantity, that.pricingQuantity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, schema, tags, labels, sourceWt, sourceId, version, usage, pricingQuantity);
    }

    @Override
    public String toString() {
        return "BillingDryRunResponseMetric{" +
                "id='" + id + '\'' +
                ", schema='" + schema + '\'' +
                ", tags=" + tags +
                ", labels=" + labels +
                ", sourceWt=" + sourceWt +
                ", sourceId='" + sourceId + '\'' +
                ", version='" + version + '\'' +
                ", usage=" + usage +
                ", pricingQuantity=" + pricingQuantity +
                '}';
    }

}
