package ru.yandex.qe.dispenser.ws.billing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigDecimal;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BillingDryRunResponseMetricUsage {

    private final long start;
    private final long finish;
    private final BigDecimal quantity;
    private final String type;
    private final String unit;

    @JsonCreator
    public BillingDryRunResponseMetricUsage(@JsonProperty("start") long start,
                                            @JsonProperty("finish") long finish,
                                            @JsonProperty("quantity") BigDecimal quantity,
                                            @JsonProperty("type") String type,
                                            @JsonProperty("unit") String unit) {
        this.start = start;
        this.finish = finish;
        this.quantity = quantity;
        this.type = type;
        this.unit = unit;
    }

    public long getStart() {
        return start;
    }

    public long getFinish() {
        return finish;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public String getType() {
        return type;
    }

    public String getUnit() {
        return unit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BillingDryRunResponseMetricUsage that = (BillingDryRunResponseMetricUsage) o;
        return start == that.start &&
                finish == that.finish &&
                Objects.equals(quantity, that.quantity) &&
                Objects.equals(type, that.type) &&
                Objects.equals(unit, that.unit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(start, finish, quantity, type, unit);
    }

    @Override
    public String toString() {
        return "BillingDryRunResponseMetricUsage{" +
                "start=" + start +
                ", finish=" + finish +
                ", quantity=" + quantity +
                ", type='" + type + '\'' +
                ", unit='" + unit + '\'' +
                '}';
    }
}
