package ru.yandex.qe.dispenser.ws.bot

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty
import io.swagger.annotations.ApiModel
import io.swagger.annotations.ApiModelProperty
import java.time.LocalDate

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Big order.")
data class BigOrderDto @JsonCreator constructor(
    @get:ApiModelProperty(value = "Big order id.", required = true)
    @JsonProperty("id")
    val id: Long,
    @get:ApiModelProperty(value = "Big order date.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    @JsonProperty("date")
    val date: LocalDate
)
