package ru.yandex.qe.dispenser.ws.bot;

import java.time.LocalDate;
import java.time.Month;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequest;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.domain.util.BigOrderLegacy;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.ServiceBase;

@ParametersAreNonnullByDefault
@Controller
@Path("/v1/bot/big-orders")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@org.springframework.stereotype.Service("botBigOrders")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
@Deprecated
public class BotBigOrderService {

    // See DISPENSER-1569
    // TODO Get rid of isValid
    @Deprecated
    private static final LocalDate VALID_FROM = LocalDate.of(2020, Month.JANUARY, 1);

    @Autowired
    private BigOrderManager bigOrderManager;

    @GET
    @Deprecated
    public DiListResponse<DiQuotaChangeRequest.Order> getOrdersGiveOutDates() {
        return new DiListResponse<>(bigOrderManager.getAll().stream()
                .map(BigOrderLegacy::toView)
                .collect(Collectors.toList()));
    }

}
