package ru.yandex.qe.dispenser.ws.bot;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.bot.BotServiceConfiguration;
import ru.yandex.qe.dispenser.domain.bot.Configuration;
import ru.yandex.qe.dispenser.domain.dao.bot.BotConfiguration;
import ru.yandex.qe.dispenser.domain.dao.bot.configuration.BotConfigurationDao;
import ru.yandex.qe.dispenser.domain.dao.bot.service.BotServiceConfigurationDao;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.Access;
import ru.yandex.qe.dispenser.ws.ServiceBase;

@ParametersAreNonnullByDefault
@Controller
@Path("/v1/bot/configurations")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@org.springframework.stereotype.Service("botConfigurations")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
@Deprecated
public class BotConfigurationService {

    public static final String SERVICE_KEY = "service_key";

    @Autowired
    private BotConfigurationDao botConfigurationDao;

    @Autowired
    private BotServiceConfigurationDao botServiceConfigurationDao;

    @GET
    @Access
    @Deprecated
    public DiListResponse<Configuration> getConfigurations() {
        final List<Configuration> configurations = botConfigurationDao.getAll().stream()
                .map(BotConfiguration::getConfiguration)
                .collect(Collectors.toList());

        return new DiListResponse<>(configurations);
    }

    @GET
    @Access
    @Path("service/{" + SERVICE_KEY + "}")
    @Deprecated
    public DiListResponse<BotServiceConfiguration.View> getLinkedConfiguration(@PathParam(SERVICE_KEY) final Service service) {
        return new DiListResponse<>(botServiceConfigurationDao.getByServiceViews(service));
    }

    @PUT
    @Access(serviceAdmin = true)
    @Path("service/{" + SERVICE_KEY + "}")
    @Deprecated
    public DiListResponse<BotServiceConfiguration.View> setLinkedConfiguration(@PathParam(SERVICE_KEY) final Service service,
                                                                               @Nullable @QueryParam("botCampaignGroupId") final BotCampaignGroup botCampaignGroup,
                                                                               @RequestBody final List<BotServiceConfiguration.Body> configurationBodies) {
        if (botCampaignGroup == null) {
            throw new IllegalArgumentException("'botCampaignGroupId' query param is required!");
        }
        return new DiListResponse<>(Collections.emptyList());
    }


}
