package ru.yandex.qe.dispenser.ws.bot;

import java.util.Collection;
import java.util.Collections;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import ru.yandex.qe.dispenser.api.v1.request.quota.Body;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.dao.bot.MappedPreOrder;
import ru.yandex.qe.dispenser.domain.util.ValidationUtils;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.Access;
import ru.yandex.qe.dispenser.ws.ServiceBase;

/**
 * API for request-to-preorder conversion evaluating
 */
@ParametersAreNonnullByDefault
@Path("/v1/bot/pre-orders/from-requests")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@org.springframework.stereotype.Service("botPreOrderCalculation")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
@Deprecated
public class BotPreOrderCalculationService {

    @POST
    @Access
    @ApiOperation(
            value = "Convert requests to pre-orders",
            response = MappedPreOrder.View.class,
            responseContainer = "List"
    )
    @Deprecated
    public DiListResponse<MappedPreOrder.View> convertRequestsToPreOrders(
            @ApiParam(value = "List of requests", required = true)
            @NotNull final Collection<Body> bodies,
            @ApiParam(value = "Campaign Group Id", required = true)
            @Nullable @QueryParam("botCampaignGroupId") final BotCampaignGroup botCampaignGroup
    ) {
        if (botCampaignGroup == null) {
            throw new IllegalArgumentException("No campaign group id provided");
        }
        bodies.forEach(ValidationUtils::validateQuotaChangeRequestCreateBody);

        return new DiListResponse<>(Collections.emptyList());
    }

}
