package ru.yandex.qe.dispenser.ws.bot;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.domain.BotCampaignGroup;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.bot.MappedPreOrder;
import ru.yandex.qe.dispenser.domain.dao.bot.preorder.MappedPreOrderDao;
import ru.yandex.qe.dispenser.domain.dao.bot.settings.BotCampaignGroupDao;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.Access;
import ru.yandex.qe.dispenser.ws.ServiceBase;

@ParametersAreNonnullByDefault
@Path("/v1/bot/pre-orders")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@org.springframework.stereotype.Service("botPreOrders")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
@Deprecated
public class BotPreOrderService {

    private static final String BIG_ORDER_ID = "big_order_id";
    private static final String SERVICE_KEY = "service_key";
    private static final String CAMPAIGN_GROUP_ID = "campaign_group_id";

    @Autowired
    private MappedPreOrderDao mappedPreOrderDao;

    @Autowired
    private BotCampaignGroupDao botCampaignGroupDao;

    @POST
    @Path("_all")
    @Access(dispenserAdmin = true)
    @Deprecated
    public CreatedPreOrders createPreAllOrders() {
        final Set<BotCampaignGroup> activeGroups = botCampaignGroupDao.getActiveGroups();
        if (activeGroups.isEmpty()) {
            throw new IllegalArgumentException("No active campaign groups are available");
        }
        final BotPreOrderErrorsCollection errors = new BotPreOrderErrorsCollection();
        for (BotCampaignGroup activeGroup : activeGroups) {
            if (activeGroup.getActiveCampaigns().isEmpty()) {
                errors.addError("Campaign group '" + activeGroup.getName() + "' has no active campaign at this moment");
            }
        }
        return new CreatedPreOrders(new DiListResponse<>(Collections.emptyList()), errors);
    }

    @POST
    @Access(dispenserAdmin = true)
    @Deprecated
    public CreatedPreOrders createPreOrders(@QueryParam(SERVICE_KEY) @NotNull final Service service) {
        final Set<BotCampaignGroup> activeGroups = botCampaignGroupDao.getActiveGroups();
        if (activeGroups.isEmpty()) {
            throw new IllegalArgumentException("No active campaign groups are available");
        }
        final BotPreOrderErrorsCollection errors = new BotPreOrderErrorsCollection();
        for (BotCampaignGroup activeGroup : activeGroups) {
            if (activeGroup.getActiveCampaigns().isEmpty()) {
                errors.addError("Campaign group '" + activeGroup.getName() + "' has no active campaign at this moment");
            }
        }
        return new CreatedPreOrders(new DiListResponse<>(Collections.emptyList()), errors);
    }

    @GET
    @Access
    @Deprecated
    public DiListResponse<MappedPreOrder.View> getPreOrders(@QueryParam(BIG_ORDER_ID) @NotNull final Long bigOrderId,
                                                            @QueryParam(SERVICE_KEY) @NotNull final Service service,
                                                            @QueryParam(CAMPAIGN_GROUP_ID) @NotNull final Long campaignGroupId) {
        final Project project = Hierarchy.get().getProjectReader().getRoot();
        final BotCampaignGroup campaignGroup = botCampaignGroupDao.read(campaignGroupId);
        if (campaignGroup.getBigOrders().stream().noneMatch(o -> Long.valueOf(o.getId()).equals(bigOrderId))) {
            throw new IllegalArgumentException("Big order '" + bigOrderId + "' is not in the campaign group '" + campaignGroupId + "'");
        }
        final Set<MappedPreOrder> preOrders = mappedPreOrderDao.readByProjectAndServiceAndBigOrder(project, service, bigOrderId, campaignGroupId);
        return new DiListResponse<>(preOrders.stream()
                .map(MappedPreOrder::toView)
                .collect(Collectors.toList()));
    }

}
