package ru.yandex.qe.dispenser.ws.bot;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;

import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import ru.yandex.qe.dispenser.ws.base_resources.impl.BaseResourceChangesRefreshManager;
import ru.yandex.qe.dispenser.ws.base_resources.impl.BaseResourceChangesRefreshTask;

@Configuration
@ParametersAreNonnullByDefault
@Profile("bot-sync")
public class BotSyncConfiguration {

    @NotNull
    private final BaseResourceChangesRefreshManager baseResourceChangesRefreshManager;

    @Inject
    public BotSyncConfiguration(final @NotNull BaseResourceChangesRefreshManager baseResourceChangesRefreshManager) {
        this.baseResourceChangesRefreshManager = baseResourceChangesRefreshManager;
    }

    @Bean
    @Profile("secondary")
    public BaseResourceChangesRefreshTask getBaseResourceChangesRefreshTask() {
        return new BaseResourceChangesRefreshTask(baseResourceChangesRefreshManager);
    }

}
