package ru.yandex.qe.dispenser.ws.bot;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.domain.dao.bot.MappedPreOrder;

public class CreatedPreOrders {

    private final DiListResponse<MappedPreOrder.View> preOrders;
    private final BotPreOrderErrorsCollection errors;

    @JsonCreator
    public CreatedPreOrders(
            @JsonProperty("preOrders") final DiListResponse<MappedPreOrder.View> preOrders,
            @JsonProperty("errors") final BotPreOrderErrorsCollection errors) {
        this.preOrders = preOrders;
        this.errors = errors;
    }

    public DiListResponse<MappedPreOrder.View> getPreOrders() {
        return preOrders;
    }

    public BotPreOrderErrorsCollection getErrors() {
        return errors;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final CreatedPreOrders that = (CreatedPreOrders) o;
        return Objects.equals(preOrders, that.preOrders) &&
                Objects.equals(errors, that.errors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preOrders, errors);
    }

    @Override
    public String toString() {
        return "CreatedPreOrders{" +
                "preOrders=" + preOrders +
                ", errors=" + errors +
                '}';
    }

}
