package ru.yandex.qe.dispenser.ws.bot

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty
import io.swagger.annotations.ApiModel
import io.swagger.annotations.ApiModelProperty
import java.time.LocalDate

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Big order update.")
data class UpdateBigOrderDto @JsonCreator constructor(
    @get:ApiModelProperty(value = "Big order date.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    @JsonProperty("date")
    val date: LocalDate?
)
