package ru.yandex.qe.dispenser.ws.bot.mapping;

import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;

public enum Location {
    MAN("MAN"),
    SAS("SAS"),
    VLA("VLA"),
    MYT("MYT"),
    IVA("IVA"),
    ;

    private final String key;

    Location(final String key) {
        this.key = key;
    }

    public Segment getSegment() {
        return Hierarchy.get().getSegmentReader().read(key);
    }

    public boolean is(final Segment segment) {
        return key.equals(segment.getPublicKey());
    }

    @Nullable
    public static Location fromKey(final String key) {
        for (final Location value : values()) {
            if (value.key.equals(key)) {
                return value;
            }
        }
        return null;
    }
}
