package ru.yandex.qe.dispenser.ws.common.model.response;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class ErrorResponse {

    private final Set<String> errors;
    private final Map<String, Set<String>> fieldErrors;
    private final Map<String, Set<Object>> details;

    @JsonCreator
    public ErrorResponse(
            @JsonProperty("errors") final Set<String> errors,
            @JsonProperty("fieldErrors") final Map<String, Set<String>> fieldErrors,
            @JsonProperty("details") final Map<String, Set<Object>> details) {
        this.errors = errors;
        this.fieldErrors = fieldErrors;
        this.details = details;
    }

    public Set<String> getErrors() {
        return errors;
    }

    public Map<String, Set<String>> getFieldErrors() {
        return fieldErrors;
    }

    public Map<String, Set<Object>> getDetails() {
        return details;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ErrorResponse that = (ErrorResponse) o;
        return errors.equals(that.errors) &&
                fieldErrors.equals(that.fieldErrors) &&
                details.equals(that.details);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errors, fieldErrors, details);
    }

    @Override
    public String toString() {
        return "ErrorResponse{" +
                "errors=" + errors +
                ", fieldErrors=" + fieldErrors +
                ", details=" + details +
                '}';
    }

}
