package ru.yandex.qe.dispenser.ws.d;

import java.util.List;
import java.util.Set;

import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.RequestBody;

import ru.yandex.qe.dispenser.api.v1.DiQuota;
import ru.yandex.qe.dispenser.api.v1.DiQuotaLightView;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.ws.reqbody.MaxValueBody;

/**
 * DApiV1Provisions.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 15-04-2022
 */
@Path("dispenser")
@Produces({"application/json"})
@Consumes({"application/json"})
public interface DLegacyApi {
    @POST
    @Path("/db/api/v1/quotas/{project_key}/{service_key}/{resource_key}/{quota_spec_key}")
    DiQuota update(
            @PathParam("project_key") @NotNull final String projectKey,
            @PathParam("service_key") @NotNull final String serviceKey,
            @PathParam("resource_key") @NotNull final String resourceKey,
            @PathParam("quota_spec_key") @NotNull final String quotaSpecKey,
            @HeaderParam("X-Yandex-UID") String uid,
            @RequestBody final MaxValueBody maxValue
    );

    @GET
    @Path("/common/api/v1/projects")
    Response filterProjects(
            @QueryParam("leaf") @DefaultValue("false") final boolean leaf,
            @QueryParam("responsible") @NotNull final List<String> responsibleLogins,
            @QueryParam("member") @NotNull final List<String> memberLogins,
            @QueryParam("project") @NotNull final List<String> projectKeys,
            @QueryParam("showPersons") @DefaultValue("false") final boolean showPersons,
            @QueryParam("nocache") @DefaultValue("false") final boolean cacheDisabled,
            @Nullable @QueryParam("fields") final String fieldsParam,
            @Nullable @QueryParam("field") final Set<String> fieldParam
    );

    /**
     * Read quotas
     * @param resourceParams "/{serviceKey}/{resourceKey}"
     * @param entitySpecParams "{serviceKey}/{entitySpecKey}"
     * @param order "ASC" or "DESC"
     */
    @GET
    @Path("/db/api/v2/quotas")
    DiListResponse<DiQuotaLightView> read(
            @QueryParam("resource") final List<String> resourceParams,
            @QueryParam("entitySpec") final List<String> entitySpecParams,
            @QueryParam("segment") final Set<String> segmentKeys,
            @QueryParam("service") final Set<String> serviceKeys,
            @QueryParam("project") final Set<String> projectAbcServiceSlugs,
            @QueryParam("member") final Set<String> memberLogins,
            @QueryParam("leaf") @DefaultValue("false") final boolean leafProjects,
            @QueryParam("order") final String order
    );
}
