package ru.yandex.qe.dispenser.ws.front;

import java.util.Set;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

import ru.yandex.qe.dispenser.domain.dictionaries.model.FrontDictionaries;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.Access;
import ru.yandex.qe.dispenser.ws.ServiceBase;
import ru.yandex.qe.dispenser.ws.common.domain.errors.ErrorCollection;
import ru.yandex.qe.dispenser.ws.common.domain.errors.TypedError;
import ru.yandex.qe.dispenser.ws.common.domain.result.Result;
import ru.yandex.qe.dispenser.ws.common.impl.ResultToResponse;
import ru.yandex.qe.dispenser.ws.common.model.response.ErrorResponse;

@Path("/front/dictionaries")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@Service("dictionaries")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class FrontDictionariesService {

    @NotNull
    private final FrontDictionariesCollectManager frontDictionariesCollectManager;

    @Inject
    public FrontDictionariesService(@NotNull final FrontDictionariesCollectManager frontDictionariesCollectManager) {
        this.frontDictionariesCollectManager = frontDictionariesCollectManager;
    }

    @GET
    @Access
    @NotNull
    @ApiOperation(value = "Get frontend dictionaries")
    @ApiResponses({@ApiResponse(code = 200, message = "Successful response", response = FrontDictionaries.class),
            @ApiResponse(code = 400, message = "Illegal argument response", response = ErrorResponse.class)})
    public Response getDictionaries(@NotNull @QueryParam("dictionaries") final Set<String> dictionaries,
                                    @Nullable @QueryParam("campaignId") final Long campaignId) {
        final Result<FrontDictionaries, ErrorCollection<String, TypedError<String>>> result =
                frontDictionariesCollectManager.getFrontDictionaries(campaignId, dictionaries);
        return ResultToResponse.toResponse(result);
    }

}
