package ru.yandex.qe.dispenser.ws.goal;

import java.net.URI;
import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.startrek.client.model.StatusRef;

public class GoalIssue {
    private final String id;
    private final String key;
    private final String summary;
    private final List<LocalLinkRef> links;
    private final GoalImportance importance;
    private final StatusRef status;

    @JsonCreator
    public GoalIssue(@JsonProperty("id") final String id,
                     @JsonProperty("key") final String key,
                     @JsonProperty("summary") final String summary,
                     @JsonProperty("goalImportance") final GoalImportance importance,
                     @JsonProperty("status") final StatusRef status,
                     @JsonProperty("localLinkRefs") final List<LocalLinkRef> links) {
        this.id = id;
        this.key = key;
        this.summary = summary;
        this.importance = importance;
        this.status = status;
        this.links = links == null ? Collections.emptyList() : links;
    }

    public String getId() {
        return id;
    }

    public String getKey() {
        return key;
    }

    public String getSummary() {
        return summary;
    }

    public List<LocalLinkRef> getLinks() {
        return links;
    }

    public GoalImportance getImportance() {
        return importance;
    }

    public StatusRef getStatus() {
        return status;
    }

    public static class LocalLinkRef {
        private final URI self;
        private final String id;
        private final String relationship;
        private final String issueId;

        @JsonCreator
        public LocalLinkRef(@JsonProperty("self") final URI self,
                            @JsonProperty("id") final String id,
                            @JsonProperty("relationship") final String relationship,
                            @JsonProperty("issueId") final String issueId) {
            this.self = self;
            this.id = id;
            this.relationship = relationship;
            this.issueId = issueId;
        }

        public URI getSelf() {
            return self;
        }

        public String getId() {
            return id;
        }

        public String getRelationship() {
            return relationship;
        }

        public String getIssueId() {
            return issueId;
        }
    }

    public static class GoalImportance {
        private final URI self;
        private final String id;

        @JsonCreator
        public GoalImportance(@JsonProperty("self") final URI self,
                              @JsonProperty("id") final String id) {
            this.self = self;
            this.id = id;
        }

        public URI getSelf() {
            return self;
        }

        public String getId() {
            return id;
        }
    }
}
