package ru.yandex.qe.dispenser.ws.goal;

import java.net.URISyntaxException;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.inside.goals.GoalsClient;
import ru.yandex.qe.dispenser.domain.dao.goal.GoalDao;

@Configuration
@ParametersAreNonnullByDefault
@Profile("goal-sync")
public class GoalSync {

    private final String goalBaseUrl;
    private final String token;
    private final GoalDao goalDao;
    private final boolean syncFromTracker;
    private final TrackerGoalClientImpl goalFetcher;
    private final TrackerGoalHelper trackerGoalHelper;

    @Autowired
    public GoalSync(final GoalDao goalDao,
                    @Value("${goal.service.url}") final String serviceUrl,
                    @Value("${goal.oauth.token}") final String token,
                    @Value("${goal.sync.from.tracker}") final boolean syncFromTracker,
                    final TrackerGoalClientImpl goalFetcher,
                    final TrackerGoalHelper trackerGoalHelper) {
        this.goalBaseUrl = serviceUrl;
        this.token = token;
        this.goalDao = goalDao;
        this.syncFromTracker = syncFromTracker;
        this.goalFetcher = goalFetcher;
        this.trackerGoalHelper = trackerGoalHelper;
    }

    @Bean
    @Profile("secondary")
    public GoalSyncTask getGoalSyncTask() throws URISyntaxException {
        final GoalsClient client = new GoalsClient(goalBaseUrl, token);
        return new GoalSyncTask(goalDao, client, syncFromTracker, goalFetcher, trackerGoalHelper);
    }
}
