package ru.yandex.qe.dispenser.ws.goal;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.domain.util.FunctionalUtils;

/**
 * этот Job создается quartz'ом через reflection, spring'овая аннотация на уровне класса не нужна.
 */
@DisallowConcurrentExecution
public class GoalSyncJob implements Job {

    private static final Logger LOG = LoggerFactory.getLogger(GoalSyncJob.class);

    // конструктор с параметрами сделать нельзя, поэтому делаем inject через setter
    @Autowired
    public void setGoalSyncTask(final GoalSyncTask goalSyncTask) {
        this.goalSyncTask = goalSyncTask;
    }

    private GoalSyncTask goalSyncTask;

    @Override
    public void execute(final JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            goalSyncTask.updateWithHealthCheck();
        } catch (final Throwable e) {
            FunctionalUtils.throwIfUnrecoverable(e);
            LOG.error("Goal sync job failed", e);
            throw new JobExecutionException(e);
        }
    }

}
