package ru.yandex.qe.dispenser.ws.goal;

import java.util.Map;

import javax.inject.Inject;

import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.inside.goals.model.Goal;

@Component
public class TrackerGoalHelper {

    private final Map<String, Goal.Importance> importanceById;

    @Inject
    public TrackerGoalHelper(@Value("#{${tracker.goal.importance}}") final Map<String, Goal.Importance> importanceById) {
        this.importanceById = importanceById;
    }

    @Nullable
    public Goal.Importance getImportanceById(final String importanceId) {
        return importanceById.get(importanceId);
    }

    public Map<String, Goal.Importance> getImportanceById() {
        return importanceById;
    }
}
