package ru.yandex.qe.dispenser.ws.health;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet( name = "TelemetryPingServlet",
        urlPatterns = {"/telemetry/ping"},
        loadOnStartup = 1)
public class TelemetryPingServlet extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(HttpServletResponse.SC_OK);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        resp.setContentType("text/plain");
        try (PrintWriter writer = resp.getWriter()) {
            writer.println("pong");
        }
    }

}
