package ru.yandex.qe.dispenser.ws.history;

import java.time.Instant;
import java.util.Optional;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.dao.history.HistoryFilter;

public class HistoryFilterImpl implements HistoryFilter {
    private final Instant from;
    private final Instant to;
    private final Set<Person> performers;
    private final Set<Long> tvmIds;

    public HistoryFilterImpl(final Instant from,
                             final Instant to,
                             final Set<Person> performers,
                             final Set<Long> tvmIds) {
        this.from = from;
        this.to = to;
        this.performers = performers;
        this.tvmIds = tvmIds;
    }

    @Override
    public Optional<Instant> getFrom() {
        return Optional.ofNullable(from);
    }

    @Override
    public Optional<Instant> getTo() {
        return Optional.ofNullable(to);
    }

    @Override
    public Set<Long> getTvmIds() {
        return tvmIds;
    }

    @Override
    public Set<Person> getPerformers() {
        return performers;
    }
}
