package ru.yandex.qe.dispenser.ws.history;

import java.time.Instant;
import java.util.Set;

import ru.yandex.qe.dispenser.api.v1.DiQuotaRequestHistoryEventType;
import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.dao.history.request.QuotaChangeRequestHistoryFilter;

public class QuotaChangeRequestHistoryFilterImpl extends HistoryFilterImpl implements QuotaChangeRequestHistoryFilter {
    private final Set<DiQuotaRequestHistoryEventType> eventTypes;

    public QuotaChangeRequestHistoryFilterImpl(final Instant from,
                                               final Instant to,
                                               final Set<Person> performers,
                                               final Set<Long> tvmIds,
                                               final Set<DiQuotaRequestHistoryEventType> eventTypes) {
        super(from, to, performers, tvmIds);
        this.eventTypes = eventTypes;
    }

    @Override
    public Set<DiQuotaRequestHistoryEventType> getEventTypes() {
        return eventTypes;
    }
}


