package ru.yandex.qe.dispenser.ws.hooks;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcePreorderFormBody {
    private final long id;
    private final String user;
    private final String service;
    private final String ticket;
    private final String quota;
    private final String comment;
    private final String advanceTicket;
    private final boolean newResources;
    private final boolean allocateAll;

    @JsonCreator
    public ResourcePreorderFormBody(@JsonProperty("id") final long id,
                                    @NotNull @JsonProperty("user") final String user,
                                    @NotNull @JsonProperty("service") final String service,
                                    @NotNull @JsonProperty("ticket") final String ticket,
                                    @NotNull @JsonProperty("quota") final String quota,
                                    @NotNull @JsonProperty("comment") final String comment,
                                    @NotNull @JsonProperty("advance-ticket") final String advanceTicket,
                                    @NotNull @JsonProperty("new-resources") final String newResources,
                                    @Nullable @JsonProperty("allocateAll") final String allocateAll ) {
        this.id = id;
        this.user = user;
        this.service = service;
        this.ticket = getTicketFromLink(ticket);
        this.quota = quota;
        this.comment = comment;
        this.advanceTicket = advanceTicket;
        this.newResources = parseBoolean(newResources);
        this.allocateAll = parseBoolean(allocateAll);
    }

    private static boolean parseBoolean(@Nullable final String allocateAll) {
        if (allocateAll == null) {
            return false;
        }
        final String trimmedAllocatedAll = allocateAll.trim();
        return trimmedAllocatedAll.equals("Yes") || trimmedAllocatedAll.equals("Да");
    }

    private static String getTicketFromLink(String ticket) {
        if (ticket.isEmpty()) {
            return ticket;
        }

        final String[] split = ticket.replaceAll("/$", "").split("/");
        return split.length == 0 ? "" : split[split.length - 1];
    }

    public String getUser() {
        return user;
    }

    public String getService() {
        return service;
    }

    public String getTicket() {
        return ticket;
    }

    public String getQuota() {
        return quota;
    }

    public String getComment() {
        return comment;
    }

    public long getId() {
        return id;
    }

    @JsonProperty("advance-ticket")
    public String getAdvanceTicket() {
        return advanceTicket;
    }

    @JsonProperty("new-resources")
    public boolean isNewResources() {
        return newResources;
    }

    public boolean isAllocateAll() {
        return allocateAll;
    }

    @Override
    public String toString() {
        return "ResourcePreorderFormBody{" +
                "id=" + id +
                ", user='" + user + '\'' +
                ", service='" + service + '\'' +
                ", ticket='" + ticket + '\'' +
                ", quota='" + quota + '\'' +
                ", comment='" + comment + '\'' +
                ", advanceTicket='" + advanceTicket + '\'' +
                ", newResources='" + newResources + '\'' +
                ", allocateAll=" + allocateAll +
                '}';
    }
}
