package ru.yandex.qe.dispenser.ws.iam;

import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import javax.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

@Component
@Profile("billing-integration")
public class IAMDestination {

    private final IAMTokenSupplier iamTokenSupplier;

    @Inject
    public IAMDestination(IAMTokenSupplier iamTokenSupplier) {
        this.iamTokenSupplier = iamTokenSupplier;
    }

    public void runAuthorized(final Runnable r) {
        runAuthorized(Executors.callable(r, null));
    }

    public <V> V runAuthorized(final Callable<V> callable) {
        String iamToken = iamTokenSupplier.getToken();
        IAMIdentity requestIdentity = new IAMIdentity(iamToken);
        try {
            return requestIdentity.callWith(callable);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
