package ru.yandex.qe.dispenser.ws.iam;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IAMFeature extends AbstractFeature {

    @Override
    protected void initializeProvider(final InterceptorProvider provider, final Bus bus) {
        provider.getOutInterceptors().add(0, new OutIAMInterceptor());
    }

    private static class OutIAMInterceptor extends AbstractPhaseInterceptor<Message> {

        private OutIAMInterceptor() {
            super(Phase.POST_LOGICAL);
        }

        @Override
        public void handleMessage(final Message message) throws Fault {
            if (!isRequestor(message)) {
                return;
            }
            final Map<String, List<String>> headersMap = getHeadersMap(message);
            final IAMIdentity iamIdentity = IAMIdentity.get();
            iamIdentity.getIamToken().ifPresent(t -> headersMap.put("X-YaCloud-SubjectToken", Collections.singletonList(t)));
        }

        @NotNull
        @SuppressWarnings("unchecked")
        private Map<String, List<String>> getHeadersMap(final Message message) {
            Map<String, List<String>> headersMap = (Map<String, List<String>>) message.get(Message.PROTOCOL_HEADERS);
            if (headersMap == null) {
                headersMap = new HashMap<>();
                message.put(Message.PROTOCOL_HEADERS, headersMap);
            }
            return headersMap;
        }

    }

}
