package ru.yandex.qe.dispenser.ws.iam;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.Callable;

public class IAMIdentity {

    private final String iamToken;

    private static final ThreadLocal<Deque<IAMIdentity>> stack = ThreadLocal.withInitial(ArrayDeque::new);

    private IAMIdentity(IAMIdentity other) {
        this(other.iamToken);
    }

    public IAMIdentity(String iamToken) {
        this.iamToken = iamToken;
    }

    public <T> T callWith(Callable<T> supplier) throws Exception {
        enter();
        try {
            return supplier.call();
        } finally {
            exit();
        }
    }

    public void runWith(Runnable runnable) {
        enter();
        try {
            runnable.run();
        } finally {
            exit();
        }
    }

    public Optional<String> getIamToken() {
        return Optional.ofNullable(iamToken);
    }

    public static IAMIdentity get() {
        IAMIdentity current = stack.get().peek();
        if (current == null) {
            return new IAMIdentity((String) null);
        } else {
            return current;
        }
    }

    public static void reset() {
        stack.get().clear();
    }

    private static void exit() {
        stack.get().pop();
    }

    private void enter() {
        stack.get().push(new IAMIdentity(this));
    }

}
