package ru.yandex.qe.dispenser.ws.iam;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.qe.dispenser.domain.util.FunctionalUtils;

@DisallowConcurrentExecution
public class IAMTokenRefreshJob implements Job {

    private static final Logger LOG = LoggerFactory.getLogger(IAMTokenRefreshJob.class);

    private IAMTokenSupplier iamTokenSupplier;

    @Autowired
    public void setIamTokenSupplier(IAMTokenSupplier iamTokenSupplier) {
        this.iamTokenSupplier = iamTokenSupplier;
    }

    @Override
    public void execute(final JobExecutionContext context) throws JobExecutionException {
        try {
            iamTokenSupplier.refresh();
        } catch (final Throwable e) {
            FunctionalUtils.throwIfUnrecoverable(e);
            LOG.error("IAM token refresh job failed", e);
            throw new JobExecutionException(e);
        }
    }

}
