package ru.yandex.qe.dispenser.ws.iam;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class IAMTokenRequest {

    private final String yandexPassportOauthToken;

    @JsonCreator
    public IAMTokenRequest(@JsonProperty("yandexPassportOauthToken") String yandexPassportOauthToken) {
        this.yandexPassportOauthToken = yandexPassportOauthToken;
    }

    public String getYandexPassportOauthToken() {
        return yandexPassportOauthToken;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IAMTokenRequest that = (IAMTokenRequest) o;
        return Objects.equals(yandexPassportOauthToken, that.yandexPassportOauthToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(yandexPassportOauthToken);
    }

    @Override
    public String toString() {
        return "IAMTokenRequest{" +
                "yandexPassportOauthToken='" + yandexPassportOauthToken + '\'' +
                '}';
    }

}
