package ru.yandex.qe.dispenser.ws.iam;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class IAMTokenResponse {
    @Nullable
    private final String iamToken;

    @JsonCreator
    public IAMTokenResponse(@JsonProperty("iamToken") @Nullable String iamToken) {
        this.iamToken = iamToken;
    }

    public Optional<String> getIamToken() {
        return Optional.ofNullable(iamToken);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IAMTokenResponse that = (IAMTokenResponse) o;
        return Objects.equals(iamToken, that.iamToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(iamToken);
    }

    @Override
    public String toString() {
        return "IAMTokenResponse{" +
                "iamToken='" + iamToken + '\'' +
                '}';
    }

}
