package ru.yandex.qe.dispenser.ws.intercept;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DiFeature extends AbstractFeature {
    @Autowired
    private MDCReqIdSetter mdcReqIdSetter;
    @Autowired
    private SessionInitializer sessionInitializer;
    @Autowired
    private InnerRequestIdMemoization innerRequestIdMemoization;
    @Autowired
    private EndpointMemoization endpointMemoization;

    @Override
    public void initializeProvider(@NotNull final InterceptorProvider provider, @NotNull final Bus bus) {
        provider.getInInterceptors().add(mdcReqIdSetter);
        provider.getInInterceptors().add(sessionInitializer);
        provider.getInInterceptors().add(innerRequestIdMemoization);
        provider.getInInterceptors().add(endpointMemoization);
    }
}
