package ru.yandex.qe.dispenser.ws.intercept;

import javax.servlet.http.HttpServletRequest;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

import ru.yandex.qe.bus.features.log.OnReceiveInLogInterceptor;

@Component
public class InnerRequestIdMemoization extends InterceptorBase<Message> {

    protected InnerRequestIdMemoization() {
        super(Phase.RECEIVE);
        addAfter(OnReceiveInLogInterceptor.class.getName());
    }

    @Override
    public void handleMessage(final Message message) throws Fault {
        final String requestId = MDC.get("X-qe-bus-request-id");
        if (requestId == null) {
            return;
        }
        final Object httpRequest = message.getContextualProperty(AbstractHTTPDestination.HTTP_REQUEST);
        if (httpRequest instanceof HttpServletRequest) {
            ((HttpServletRequest) httpRequest).setAttribute(AccessLogFilter.INNER_REQ_ID, requestId);
        }
    }

}
