package ru.yandex.qe.dispenser.ws.intercept;

import java.io.IOException;
import java.util.Objects;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.http.HttpStatus;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.util.MoreHeaders;
import ru.yandex.qe.dispenser.api.util.SerializationUtils;
import ru.yandex.qe.dispenser.client.v1.impl.DispenserConfig;
import ru.yandex.qe.dispenser.domain.util.ApplicationContextProvider;

public final class JavaClientAccessFilter implements Filter {
    @Override
    public void init(@NotNull final FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(@NotNull final ServletRequest request,
                         @NotNull final ServletResponse response,
                         @NotNull final FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest req = (HttpServletRequest) request;
        final HttpServletResponse resp = (HttpServletResponse) response;

        final String clientInfoHeader = req.getHeader(MoreHeaders.X_DISPENSER_CLIENT_INFO);
        if (clientInfoHeader == null) {
            chain.doFilter(request, response);
            return;
        }
        final DispenserConfig.ClientInfo clientInfo = SerializationUtils.readValue(clientInfoHeader, DispenserConfig.ClientInfo.class);
        final DispenserConfig.Environment env = ApplicationContextProvider.getBean(DispenserConfig.Environment.class);
        Objects.requireNonNull(env, "DispenserConfig.Environment is required!");
        if (env == clientInfo.getEnvironment()) {
            chain.doFilter(request, response);
            return;
        }
        resp.sendError(HttpStatus.SC_FORBIDDEN, "Your can't access to " + env + " server from " + clientInfo.getEnvironment() + " java client!");
    }

    @Override
    public void destroy() {
    }
}
