package ru.yandex.qe.dispenser.ws.intercept;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.qe.bus.features.log.OnReceiveInLogInterceptor;
import ru.yandex.qe.dispenser.api.DiRequest;
import ru.yandex.qe.dispenser.client.v1.impl.DiRequestImpl;
import ru.yandex.qe.dispenser.ws.Idempotent;

@Component
public class MDCReqIdSetter extends InterceptorBase<Message> {
    private static final String REQUEST_ID_HEADER_KEY = "X-qe-bus-request-id";

    protected MDCReqIdSetter() {
        super(Phase.RECEIVE);
        addBefore(OnReceiveInLogInterceptor.class.getName());
    }

    @Override
    public void handleMessage(@NotNull final Message message) throws Fault {
        final DiRequest<?> request = new DiRequestImpl(message);
        final String reqId = request.getQueryParam(Idempotent.REQUEST_ID);
        if (reqId != null) {
            request.setHeader(REQUEST_ID_HEADER_KEY, reqId);
        }
    }
}
