package ru.yandex.qe.dispenser.ws.intercept;

import java.util.Optional;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

import ru.yandex.qe.dispenser.domain.hierarchy.Session;

public final class MockPreAuthFilter extends AbstractPreAuthenticatedProcessingFilter {

    private static final long UID = 1120000000128362L;

    public MockPreAuthFilter() {
        setAuthenticationManager(auth -> auth);
        setCheckForPrincipalChanges(true);
    }

    @Nullable
    @Override
    protected Object getPreAuthenticatedPrincipal(@NotNull final HttpServletRequest req) {
        final String login = Optional.ofNullable(req.getHeader(HttpHeaders.AUTHORIZATION)).map(this::getLogin).orElse(null);
        Session.AUTH_LOGIN.set(login);
        req.setAttribute(AccessLogFilter.LOGIN, login);
        req.setAttribute(AccessLogFilter.UID, String.valueOf(UID));
        return login;
    }

    @Override
    protected Object getPreAuthenticatedCredentials(@NotNull final HttpServletRequest req) {
        return "N/A";
    }

    @NotNull
    private String getLogin(@NotNull final String authorization) {
        return authorization.replaceFirst("OAuth ", "");
    }
}
