package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.ws.abc.ProjectTreeSyncTask;

@DisallowConcurrentExecution
public class AbcSyncJob extends AbstractJobWithHierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(AbcSyncJob.class);

    private ProjectTreeSyncTask projectTreeSyncTask;

    public AbcSyncJob() {
        super(LOG);
    }

    @Inject
    public void setProjectTreeSyncTask(final ProjectTreeSyncTask projectTreeSyncTask) {
        this.projectTreeSyncTask = projectTreeSyncTask;
    }

    @Override
    protected void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException {
        projectTreeSyncTask.update();
    }
}
