package ru.yandex.qe.dispenser.ws.job;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;

import ru.yandex.qe.dispenser.domain.util.FunctionalUtils;

public abstract class AbstractErrorLoggingJob implements Job {
    private final Logger logger;

    protected AbstractErrorLoggingJob(final Logger logger) {
        this.logger = logger;
    }

    protected abstract void executeWithErrorCheck(final JobExecutionContext context) throws JobExecutionException;

    @Override
    public void execute(final JobExecutionContext context) throws JobExecutionException {
        try {
            executeWithErrorCheck(context);
        } catch (final JobExecutionException e) {
            throw e;
        } catch (final Throwable e) {
            FunctionalUtils.throwIfUnrecoverable(e);
            logger.error(this.getClass().getSimpleName() + " failed", e);
            throw new JobExecutionException(e);
        }
    }
}
