package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.qe.dispenser.domain.hierarchy.HierarchySupplier;
import ru.yandex.qe.dispenser.domain.hierarchy.Session;

public abstract class AbstractJobWithHierarchy extends AbstractErrorLoggingJob {

    private HierarchySupplier hierarchySupplier;
    private boolean isHierarchyEnabled;

    protected AbstractJobWithHierarchy(final Logger logger) {
        super(logger);
    }

    @Inject
    public void setHierarchySupplier(final HierarchySupplier hierarchySupplier) {
        this.hierarchySupplier = hierarchySupplier;
    }

    @Value("${hierarchy.enabled}")
    public void setHierarchyEnabled(final boolean hierarchyEnabled) {
        isHierarchyEnabled = hierarchyEnabled;
    }

    @Override
    public void executeWithErrorCheck(final JobExecutionContext context) throws JobExecutionException {
        if (isHierarchyEnabled) {
            Session.HIERARCHY.set(hierarchySupplier.get());
        }
        executeWithHierarchy(context);
    }

    protected abstract void executeWithHierarchy(final JobExecutionContext context) throws JobExecutionException;
}
