package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.ws.base_resources.impl.BaseResourceChangesRefreshTask;

@DisallowConcurrentExecution
public class BaseResourceChangesRefreshJob extends AbstractErrorLoggingJob {

    private BaseResourceChangesRefreshTask baseResourceChangesRefreshTask;

    private static final Logger LOG = LoggerFactory.getLogger(BaseResourceChangesRefreshJob.class);

    public BaseResourceChangesRefreshJob() {
        super(LOG);
    }

    @Inject
    public void setBaseResourceChangesRefreshTask(BaseResourceChangesRefreshTask baseResourceChangesRefreshTask) {
        this.baseResourceChangesRefreshTask = baseResourceChangesRefreshTask;
    }

    @Override
    protected void executeWithErrorCheck(JobExecutionContext context) {
        baseResourceChangesRefreshTask.run();
    }

}
