package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.hierarchy.HierarchySupplier;

@DisallowConcurrentExecution
public class CachingHierarchyUpdateJob extends AbstractErrorLoggingJob {
    private static final Logger LOG = LoggerFactory.getLogger(CachingHierarchyUpdateJob.class);

    private HierarchySupplier hierarchySupplier;

    public CachingHierarchyUpdateJob() {
        super(LOG);
    }

    @Inject
    public void setHierarchySupplier(final HierarchySupplier hierarchySupplier) {
        this.hierarchySupplier = hierarchySupplier;
    }

    @Override
    protected void executeWithErrorCheck(final JobExecutionContext context) throws JobExecutionException {
        hierarchySupplier.update();
    }
}
