package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.ws.quota.request.owning_cost.campaignOwningCost.CampaignOwningCostRefreshTask;

@DisallowConcurrentExecution
public class CampaignOwningCostRefreshJob extends AbstractErrorLoggingJob {

    private CampaignOwningCostRefreshTask campaignOwningCostRefreshTask;

    private static final Logger LOG = LoggerFactory.getLogger(CampaignOwningCostRefreshJob.class);

    public CampaignOwningCostRefreshJob() {
        super(LOG);
    }

    @Inject
    public void setCampaignOwningCostRefreshTask(CampaignOwningCostRefreshTask campaignOwningCostRefreshTask) {
        this.campaignOwningCostRefreshTask = campaignOwningCostRefreshTask;
    }

    @Override
    protected void executeWithErrorCheck(JobExecutionContext context) {
        campaignOwningCostRefreshTask.run();
    }
}
