package ru.yandex.qe.dispenser.ws.job;

import javax.inject.Inject;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.ws.quota.request.owning_cost.QuotaChangeOwningCostRefreshTask;

@DisallowConcurrentExecution
public class ChangesOwningCostRefreshJob extends AbstractErrorLoggingJob {

    private QuotaChangeOwningCostRefreshTask quotaChangeOwningCostRefreshTask;

    private static final Logger LOG = LoggerFactory.getLogger(ChangesOwningCostRefreshJob.class);

    public ChangesOwningCostRefreshJob() {
        super(LOG);
    }

    @Inject
    public void setQuotaChangeOwningCostRefreshTask(QuotaChangeOwningCostRefreshTask quotaChangeOwningCostRefreshTask) {
        this.quotaChangeOwningCostRefreshTask = quotaChangeOwningCostRefreshTask;
    }

    @Override
    protected void executeWithErrorCheck(JobExecutionContext context) {
        quotaChangeOwningCostRefreshTask.run();
    }
}
